/*
 * Decompiled with CFR 0.152.
 */
package test.josele.mealyandmoore;

import java.util.Iterator;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class MoorePlant
extends AtomicImpl {
    public static final String out = "out";
    public static final String in = "in";
    protected double sampleTime;
    protected double input;
    protected double output;
    protected double previousInput;
    protected double previousOutput;

    public MoorePlant(String name, double sampleTime) {
        super(name);
        super.addInport(in);
        super.addOutport(out);
        super.setSigma(0.0);
        this.sampleTime = sampleTime;
        this.input = 0.0;
        this.previousInput = 0.0;
        this.previousOutput = 0.0;
    }

    public void deltint() {
        super.setSigma(this.sampleTime);
        this.previousInput = this.input;
        this.previousOutput = this.output;
    }

    public void deltext(double e, Message x) {
        Iterator<Object> itr = x.getValuesOnPort(in).iterator();
        if (itr.hasNext()) {
            this.input = (Double)itr.next();
        }
    }

    public Message lambda() {
        MessageImpl msg = new MessageImpl();
        this.output = 0.5 * this.input + 0.3 * this.previousOutput;
        msg.add(out, this.output);
        System.out.println(super.getName() + "-->" + this.output);
        return msg;
    }
}

