/*
 * Decompiled with CFR 0.152.
 */
package xdevs.kernel.modeling;

import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import xdevs.kernel.modeling.api.AtomicDD;
import xdevs.kernel.modeling.api.CoupledDD;
import xdevs.kernel.modeling.api.DevsDess;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicDDImpl
implements AtomicDD {
    private DevsDess.TYPE type = DevsDess.TYPE.MOORE;
    private CoupledDD parent = null;
    private String name;
    private Set<String> inDiscrPortNames;
    private Set<String> inContPortNames;
    private Set<String> outDiscrPortNames;
    private Set<String> outContPortNames;

    public AtomicDDImpl(String name) {
        this.name = name;
        this.inDiscrPortNames = new HashSet<String>();
        this.inContPortNames = new HashSet<String>();
        this.outDiscrPortNames = new HashSet<String>();
        this.outContPortNames = new HashSet<String>();
    }

    public AtomicDDImpl(Element xmlNode) {
        this(xmlNode.getAttribute("name"));
    }

    @Override
    public abstract void deltint();

    @Override
    public abstract void deltext(double var1, Message var3);

    @Override
    public abstract Message lambdaCont();

    @Override
    public abstract Message lambdaDiscr();

    @Override
    public abstract void f(Message var1, double var2);

    @Override
    public abstract boolean cint(double var1);

    @Override
    public void addInport(String name, DevsDess.VALUE_TYPE value_type) {
        if (value_type == DevsDess.VALUE_TYPE.DISCR) {
            this.inDiscrPortNames.add(name);
        } else if (value_type == DevsDess.VALUE_TYPE.CONT) {
            this.inContPortNames.add(name);
        }
    }

    @Override
    public void addOutport(String name, DevsDess.VALUE_TYPE value_type) {
        if (value_type == DevsDess.VALUE_TYPE.DISCR) {
            this.outDiscrPortNames.add(name);
        } else if (value_type == DevsDess.VALUE_TYPE.CONT) {
            this.outContPortNames.add(name);
        }
    }

    @Override
    public Set<String> getInportNames(DevsDess.VALUE_TYPE value_type) {
        if (value_type == DevsDess.VALUE_TYPE.DISCR) {
            return this.inDiscrPortNames;
        }
        if (value_type == DevsDess.VALUE_TYPE.CONT) {
            return this.inContPortNames;
        }
        return null;
    }

    @Override
    public Set<String> getOutportNames(DevsDess.VALUE_TYPE value_type) {
        if (value_type == DevsDess.VALUE_TYPE.DISCR) {
            return this.outDiscrPortNames;
        }
        if (value_type == DevsDess.VALUE_TYPE.CONT) {
            return this.outContPortNames;
        }
        return null;
    }

    @Override
    public boolean containsInPort(String portName, DevsDess.VALUE_TYPE value_type) {
        if (value_type == DevsDess.VALUE_TYPE.DISCR) {
            return this.inDiscrPortNames.contains(portName);
        }
        if (value_type == DevsDess.VALUE_TYPE.CONT) {
            return this.inContPortNames.contains(portName);
        }
        return false;
    }

    @Override
    public boolean containsOutPort(String portName, DevsDess.VALUE_TYPE value_type) {
        if (value_type == DevsDess.VALUE_TYPE.DISCR) {
            return this.outDiscrPortNames.contains(portName);
        }
        if (value_type == DevsDess.VALUE_TYPE.CONT) {
            return this.outContPortNames.contains(portName);
        }
        return false;
    }

    @Override
    public DevsDess.VALUE_TYPE getInPortValueType(String portName) {
        if (this.inDiscrPortNames.contains(portName)) {
            return DevsDess.VALUE_TYPE.DISCR;
        }
        if (this.inContPortNames.contains(portName)) {
            return DevsDess.VALUE_TYPE.CONT;
        }
        return DevsDess.VALUE_TYPE.UNDEF;
    }

    @Override
    public DevsDess.VALUE_TYPE getOutPortValueType(String portName) {
        if (this.outDiscrPortNames.contains(portName)) {
            return DevsDess.VALUE_TYPE.DISCR;
        }
        if (this.outContPortNames.contains(portName)) {
            return DevsDess.VALUE_TYPE.CONT;
        }
        return DevsDess.VALUE_TYPE.UNDEF;
    }

    @Override
    public CoupledDD getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CoupledDD parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DevsDess.TYPE getType() {
        return this.type;
    }

    @Override
    public void setType(DevsDess.TYPE type) {
        this.type = type;
    }
}

