/*
 * Decompiled with CFR 0.152.
 */
package xdevs.kernel.modeling;

import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import xdevs.kernel.modeling.api.Atomic;
import xdevs.kernel.modeling.api.Coupled;
import xdevs.kernel.modeling.api.Devs;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicImpl
implements Atomic {
    private Devs.TYPE type = Devs.TYPE.MOORE;
    private Coupled parent = null;
    private String name;
    private String phase;
    private double sigma;
    private Set<String> inPortNames;
    private Set<String> outPortNames;

    public AtomicImpl(String name) {
        this.name = name;
        this.phase = "passive";
        this.sigma = Double.POSITIVE_INFINITY;
        this.inPortNames = new HashSet<String>();
        this.outPortNames = new HashSet<String>();
    }

    public AtomicImpl(Element xmlNode) {
        this(xmlNode.getAttribute("name"));
        this.setPhase(xmlNode.getAttribute("phase"));
        String sigmaAsString = xmlNode.getAttribute("sigma");
        if (sigmaAsString.equals("INFINITY")) {
            this.setSigma(Double.POSITIVE_INFINITY);
        } else {
            this.setSigma(Double.valueOf(sigmaAsString));
        }
    }

    @Override
    public double ta() {
        return this.getSigma();
    }

    @Override
    public abstract void deltint();

    @Override
    public abstract void deltext(double var1, Message var3);

    @Override
    public void deltcon(double e, Message x) {
        this.deltint();
        this.deltext(0.0, x);
    }

    @Override
    public abstract Message lambda();

    @Override
    public Message lambda(Message x) {
        return null;
    }

    @Override
    public void addInport(String name) {
        this.inPortNames.add(name);
    }

    @Override
    public void addOutport(String name) {
        this.outPortNames.add(name);
    }

    @Override
    public Set<String> getInportNames() {
        return this.inPortNames;
    }

    @Override
    public Set<String> getOutportNames() {
        return this.outPortNames;
    }

    @Override
    public boolean containsInPort(String portName) {
        return this.inPortNames.contains(portName);
    }

    @Override
    public boolean containsOutPort(String portName) {
        return this.outPortNames.contains(portName);
    }

    @Override
    public Coupled getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Coupled parent) {
        this.parent = parent;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setPhase(String phase) {
        this.phase = phase;
    }

    @Override
    public double getSigma() {
        return this.sigma;
    }

    @Override
    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public void passivate() {
        this.phase = "passive";
        this.sigma = Double.POSITIVE_INFINITY;
    }

    @Override
    public void holdIn(String phase, double sigma) {
        this.phase = phase;
        this.sigma = sigma;
    }

    @Override
    public Devs.TYPE getType() {
        return this.type;
    }

    @Override
    public void setType(Devs.TYPE type) {
        this.type = type;
    }
}

