/*
 * Decompiled with CFR 0.152.
 */
package xdevs.kernel.modeling;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import xdevs.kernel.modeling.api.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message {
    private Map<String, Collection<Object>> messages = new HashMap<String, Collection<Object>>();

    @Override
    public void add(String portName, Object value) {
        if (value == null) {
            this.messages.put(portName, null);
        } else {
            Collection<Object> values = this.messages.get(portName);
            if (values == null) {
                values = new HashSet<Object>();
                this.messages.put(portName, values);
            }
            values.add(value);
        }
    }

    @Override
    public Collection<Object> getValuesOnPort(String portName) {
        Collection<Object> values = this.messages.get(portName);
        if (values == null) {
            return new HashSet<Object>();
        }
        return values;
    }

    @Override
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Override
    public void receive(String portFrom, Message newMessage, String portTo) {
        Collection<Object> valuesFrom = newMessage.getValuesOnPort(portFrom);
        this.messages.put(portTo, valuesFrom);
    }
}

