/*
 * Decompiled with CFR 0.152.
 */
package genDevs.modeling.basicModels;

import GenCol.Bag;
import GenCol.Pair;
import GenCol.Relation;
import GenCol.doubleEnt;
import GenCol.entity;
import genDevs.modeling.message;
import java.util.Iterator;
import simView.ViewableAtomic;

public class JobQueue
extends ViewableAtomic {
    private static final long serialVersionUID = 8437805437962324889L;
    protected Relation arrived = new Relation();
    protected Bag due;
    protected double clock;
    protected double jobDueDelay;
    protected doubleEnt minimumJobTime;

    public JobQueue(String name, double jobDueDelay_) {
        super(name);
        this.addInport("in");
        this.addInport("none");
        this.addOutport("out");
        this.jobDueDelay = jobDueDelay_;
    }

    public JobQueue() {
        this("JobQueue", 10.0);
        this.addTestInput("none", new entity("job"), 1.0);
        this.addTestInput("in", new entity("job1"), 0.0);
        this.addTestInput("in", new entity("job1"), 1.0);
        this.addTestInput("in", new entity("job2"), 1.0);
        this.addTestInput("in", new entity("job3"), 1.0);
    }

    @Override
    public void initialize() {
        this.passivate();
        this.clock = 0.0;
        super.initialize();
        this.arrived = new Relation();
        this.due = new Bag();
        this.minimumJobTime = new doubleEnt(this.INFINITY);
    }

    protected void detmMinimumJobTime() {
        double min = this.INFINITY;
        if (!this.arrived.isEmpty()) {
            Iterator i = this.arrived.iterator();
            while (i.hasNext()) {
                Pair pair = (Pair)i.next();
                double time = ((doubleEnt)pair.getKey()).getv();
                if (!(time < min)) continue;
                min = time;
            }
        }
        this.minimumJobTime = new doubleEnt(min);
    }

    protected void detmDueJobs() {
        this.due = new Bag();
        Iterator i = this.arrived.iterator();
        while (i.hasNext()) {
            Pair pair = (Pair)i.next();
            if (!pair.getKey().equals(this.minimumJobTime)) continue;
            this.due.add(pair.getValue());
        }
    }

    protected void removeAllMinimumJobs() {
        Iterator i = this.arrived.iterator();
        while (i.hasNext()) {
            Pair pair = (Pair)i.next();
            if (!pair.getKey().equals(this.minimumJobTime)) continue;
            this.arrived.remove(pair.getKey(), pair.getValue());
        }
    }

    @Override
    public void deltext(double e, message message2) {
        this.clock += e;
        this.Continue(e);
        int i = 0;
        while (i < message2.getLength()) {
            if (this.messageOnPort(message2, "in", i)) {
                entity value = message2.getValOnPort("in", i);
                this.arrived.put(new doubleEnt(this.clock + this.jobDueDelay), value);
            }
            ++i;
        }
        this.deltextHook1(message2);
        this.holdUntilNextJob();
    }

    protected void deltextHook1(message message2) {
    }

    protected void holdUntilNextJob() {
        this.detmMinimumJobTime();
        if (!this.arrived.isEmpty()) {
            this.holdIn("active", this.minimumJobTime.getv() - this.clock);
        } else {
            this.passivate();
        }
        this.detmDueJobs();
    }

    @Override
    public void deltcon(double e, message message2) {
        this.deltext(e, message2);
        this.deltint();
    }

    @Override
    public void deltint() {
        this.clock += this.sigma;
        this.deltintHook1();
        this.removeAllMinimumJobs();
        this.holdUntilNextJob();
    }

    protected void deltintHook1() {
    }

    @Override
    public message out() {
        message message2 = new message();
        if (this.phaseIs("active")) {
            Iterator i = this.due.iterator();
            while (i.hasNext()) {
                message2.add(this.makeContent("out", (entity)i.next()));
            }
        }
        return message2;
    }

    @Override
    public String stringState() {
        if (this.arrived != null && this.due != null) {
            return "arrived : " + this.arrived.size() + "\n" + "clock : " + this.clock + "\n" + "min : " + this.minimumJobTime.getv() + "\n" + "due : " + this.due.size();
        }
        return "";
    }
}

