/*
 * Decompiled with CFR 0.152.
 */
package genDevs.plots;

import GenCol.doubleEnt;
import GenCol.entity;
import genDevs.modeling.basicModels.JobQueue;
import genDevs.modeling.message;
import genDevs.plots.CellGridView;
import genDevs.plots.DrawCellEntity;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Iterator;

public class CellGridPlot
extends JobQueue {
    private static final long serialVersionUID = -4911528240710284970L;
    protected CellGridView cellGridView;
    protected Point cellGridViewLocation = new Point(500, 50);
    protected double lastI = 0.0;
    protected double lastJ = 0.0;
    protected double xRange = 1.0;
    protected double yRange = 1.0;
    protected double zRange = 1.0;
    protected double timeScale;
    protected Color defaultColor = Color.blue;
    protected double lastTimePlotTime = -1.0;
    protected boolean dontDimTimePlotCells;
    protected double lastPulseTime = -1.0;
    protected boolean dontDimPulseLines;

    public CellGridPlot(String name, double jobDueDelay, String xLabel, double xRange_, String yLabel, double yRange_) {
        super(name, jobDueDelay);
        this.setHidden(true);
        this.xRange = xRange_;
        this.yRange = yRange_;
        xLabel = String.valueOf(xLabel) + " " + 0.5 * this.xRange;
        yLabel = String.valueOf(yLabel) + " " + 0.5 * this.yRange;
        this.cellGridView = new CellGridView(name, xLabel, yLabel);
        this.configureCellGridView();
        this.addInport("drawString");
        this.addInport("drawCell");
        this.addInport("drawCellToScale");
        this.addInport("drawI");
        this.addInport("drawJ");
        this.addInport("draw2D");
        this.addInport("timePlot");
        this.addInport("pulsePlot");
        this.addTestInput("drawString", new DrawCellEntity("this is a test", 15.0, 10.0, Color.red), 0.0);
        this.addTestInput("drawCell", new DrawCellEntity(15.0, 11.0, Color.black, Color.green), 0.0);
        this.addTestInput("drawCell", new DrawCellEntity(10.0, 10.0, Color.red), 0.0);
        this.addTestInput("drawI", new doubleEnt(0.5), 0.0);
        this.addTestInput("drawJ", new doubleEnt(-0.7), 0.0);
        this.addTestInput("timePlot", new doubleEnt(-0.7), 1.0);
        this.addTestInput("timePlot", new doubleEnt(0.7), 1.0);
        this.computeTimeScale();
    }

    public CellGridPlot(String name, double jobDueDelay, CellGridView cellGridView_, double zRange_) {
        super(name, jobDueDelay);
        this.cellGridView = cellGridView_;
        this.zRange = zRange_;
        this.configureCellGridView();
        this.setHidden(true);
        this.computeTimeScale();
    }

    public CellGridPlot(String name, double jobDueDelay, CellGridView cellGridView) {
        this(name, jobDueDelay, cellGridView, 1.0);
    }

    public CellGridPlot(String name, double delay, double xRange, double yRange) {
        this(name, delay, "X", xRange, "Y", yRange);
    }

    public CellGridPlot(String name, double delay, double xRange, double yRange, double zRange_) {
        this(name, delay, "X", xRange, "Y", yRange);
        this.zRange = zRange_;
    }

    public CellGridPlot(String name, double delay, String yLabel, double yRange) {
        this(name, delay, "time", 100.0, yLabel, yRange);
    }

    public CellGridPlot(String name, double delay, double yRange) {
        this(name, delay, "Y", yRange);
    }

    public CellGridPlot() {
        this("CellGridPlot", 10.0, 2.0, 2.0);
    }

    public void setCellGridViewLocation(int x, int y) {
        this.cellGridViewLocation.setLocation(x, y);
        this.cellGridView.setLocation(x, y);
    }

    public void setSpaceSize(int width, int height) {
        this.cellGridView.setSpaceSize(new Dimension(width, height));
        this.computeTimeScale();
        this.cellGridView.setXScale(this.xRange);
        this.cellGridView.setYScale(this.yRange);
    }

    protected void computeTimeScale() {
        this.timeScale = 2.2 * (double)this.cellGridView.getSpaceSize().width;
    }

    public void setCellSize(int size) {
        this.cellGridView.setCellSize(size);
    }

    public double getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(double timeScale_) {
        this.xRange = this.timeScale = timeScale_;
        this.cellGridView.setXLabel("time " + 0.5 * this.xRange);
    }

    public void setDefaultColor(Color color) {
        this.defaultColor = color;
    }

    public Color mapValueToColor(double value) {
        if ((value *= 2.0) > this.zRange) {
            return Color.red;
        }
        if (value > 0.8 * this.zRange) {
            return Color.pink;
        }
        if (value > 0.6 * this.zRange) {
            return Color.orange;
        }
        if (value > 0.4 * this.zRange) {
            return Color.yellow;
        }
        if (value > 0.2 * this.zRange) {
            return Color.green;
        }
        if (value > 0.0) {
            return Color.green;
        }
        if (value > -0.2 * this.zRange) {
            return Color.cyan;
        }
        if (value > -0.4 * this.zRange) {
            return Color.blue;
        }
        if (value > -0.6 * this.zRange) {
            return Color.magenta;
        }
        if (value > -0.8 * this.zRange) {
            return Color.gray;
        }
        return Color.black;
    }

    protected void configureCellGridView() {
        this.cellGridView.setXScale(this.xRange);
        this.cellGridView.setYScale(this.yRange);
        if (!this.cellGridView.isVisible()) {
            this.cellGridView.setVisible(true);
        }
    }

    @Override
    protected void deltextHook1(message message2) {
        doubleEnt dueTime = new doubleEnt(this.clock + this.jobDueDelay);
        int i = 0;
        while (i < message2.getLength()) {
            double value;
            entity entity2;
            if (this.messageOnPort(message2, "drawString", i)) {
                entity2 = (DrawCellEntity)message2.getValOnPort("drawString", i);
                this.arrived.put(dueTime, entity2);
                this.cellGridView.drawString((int)Math.rint(((DrawCellEntity)entity2).i), (int)Math.rint(((DrawCellEntity)entity2).j), entity2.getName(), ((DrawCellEntity)entity2).color);
                ((DrawCellEntity)entity2).setName("drawString");
            } else if (this.messageOnPort(message2, "drawCell", i)) {
                entity2 = (DrawCellEntity)message2.getValOnPort("drawCell", i);
                this.arrived.put(dueTime, entity2);
                this.cellGridView.drawCell((int)Math.rint(((DrawCellEntity)entity2).i), (int)Math.rint(((DrawCellEntity)entity2).j), ((DrawCellEntity)entity2).color);
                ((DrawCellEntity)entity2).setName("drawCell");
            } else if (this.messageOnPort(message2, "drawCellToScale", i)) {
                entity inEntity = message2.getValOnPort("drawCellToScale", i);
                DrawCellEntity entity3 = (DrawCellEntity)inEntity;
                this.arrived.put(dueTime, entity3);
                this.cellGridView.drawCellToScale(entity3.i, entity3.j, entity3.color);
                entity3.setName("drawCellToScale");
            } else if (this.messageOnPort(message2, "draw2D", i)) {
                entity2 = (DrawCellEntity)message2.getValOnPort("draw2D", i);
                this.arrived.put(dueTime, entity2);
                ((DrawCellEntity)entity2).color = this.mapValueToColor(((DrawCellEntity)entity2).k);
                this.cellGridView.drawCellToScale(((DrawCellEntity)entity2).i, ((DrawCellEntity)entity2).j, ((DrawCellEntity)entity2).color);
                ((DrawCellEntity)entity2).setName("drawCellToScale");
            } else if (this.messageOnPort(message2, "drawI", i)) {
                entity2 = (doubleEnt)message2.getValOnPort("drawI", i);
                this.lastI = ((doubleEnt)entity2).getv();
                this.arrived.put(dueTime, new DrawCellEntity("drawCellToScale", this.lastI, this.lastJ));
                this.cellGridView.drawCellToScale(this.lastI, this.lastJ, Color.black);
            } else if (this.messageOnPort(message2, "drawJ", i)) {
                entity2 = (doubleEnt)message2.getValOnPort("drawJ", i);
                this.lastJ = ((doubleEnt)entity2).getv();
                this.arrived.put(dueTime, new DrawCellEntity("drawCellToScale", this.lastI, this.lastJ));
                this.cellGridView.drawCellToScale(this.lastI, this.lastJ, Color.blue);
            } else if (this.messageOnPort(message2, "timePlot", i)) {
                entity2 = (doubleEnt)message2.getValOnPort("timePlot", i);
                double time = (-0.5 + this.clock / this.timeScale % 1.0) * this.timeScale;
                value = ((doubleEnt)entity2).getv();
                this.arrived.put(dueTime, new DrawCellEntity("drawCellToTimeScale", time, value, null, this.timeScale));
                if (time < 0.0 && this.lastTimePlotTime > 0.0) {
                    this.dontDimTimePlotCells = true;
                    this.cellGridView.clearGrid();
                }
                this.lastTimePlotTime = time;
                this.cellGridView.drawCellToTimeScale(time, this.timeScale, value, this.defaultColor);
            } else if (this.messageOnPort(message2, "pulsePlot", i)) {
                entity2 = (doubleEnt)message2.getValOnPort("pulsePlot", i);
                double time = (-0.5 + this.clock / this.timeScale % 1.0) * this.timeScale;
                value = ((doubleEnt)entity2).getv();
                this.arrived.put(dueTime, new DrawCellEntity("drawPulseToTimeScale", time, value, null, this.timeScale));
                if (time < 0.0 && this.lastPulseTime > 0.0) {
                    this.dontDimPulseLines = true;
                    this.cellGridView.clearGrid();
                }
                this.lastPulseTime = time;
                this.cellGridView.drawPulseToTimeScale(time, this.timeScale, value, this.defaultColor);
            }
            ++i;
        }
    }

    @Override
    protected void deltintHook1() {
        Iterator i = this.due.iterator();
        while (i.hasNext()) {
            DrawCellEntity entity2 = (DrawCellEntity)i.next();
            String name = entity2.getName();
            if (name.startsWith("drawCellToScale")) {
                this.cellGridView.drawCellToScale(entity2.i, entity2.j, entity2.dimTo);
                continue;
            }
            if (name.startsWith("drawCellToTimeScale")) {
                if (!this.dontDimTimePlotCells || entity2.i < 0.0) {
                    this.cellGridView.drawCellToTimeScale(entity2.i, entity2.timeScale, entity2.j, entity2.dimTo);
                    continue;
                }
                if (!this.dontDimTimePlotCells || !(entity2.i < 0.0)) continue;
                this.dontDimTimePlotCells = false;
                continue;
            }
            if (name.startsWith("drawPulseToTimeScale")) {
                if (!this.dontDimPulseLines || entity2.i < 0.0) {
                    this.cellGridView.drawPulseToTimeScale(entity2.i, entity2.timeScale, entity2.j, entity2.dimTo);
                    continue;
                }
                if (!this.dontDimPulseLines || !(entity2.i < 0.0)) continue;
                this.dontDimPulseLines = false;
                continue;
            }
            if (name.startsWith("drawCell")) {
                this.cellGridView.drawCell((int)Math.rint(entity2.i), (int)Math.rint(entity2.j), entity2.dimTo);
                continue;
            }
            if (!name.startsWith("drawString")) continue;
            this.cellGridView.drawString((int)Math.rint(entity2.i), (int)Math.rint(entity2.j), name, entity2.dimTo);
        }
    }

    @Override
    public message out() {
        return new message();
    }

    @Override
    public String stringState() {
        String graphInfo = "XRange,YRange : " + this.xRange + "," + this.yRange + "\n" + "lastI,lastJ : " + this.lastI + "," + this.lastJ;
        return String.valueOf(super.stringState()) + "\n" + graphInfo;
    }

    public CellGridView getCellGridView() {
        return this.cellGridView;
    }

    public void setCellGridView(CellGridView view) {
        this.cellGridView = view;
        this.configureCellGridView();
    }
}

