/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation;

import GenCol.EntityInterface;
import GenCol.entity;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.MessageInterface;
import genDevs.modeling.PortInterface;
import genDevs.modeling.message;
import genDevs.modeling.port;
import genDevs.simulation.AtomicSimulatorInterface;
import util.Logging;

public class atomicSimulator
implements AtomicSimulatorInterface {
    private static final long serialVersionUID = -2364756054387973013L;
    protected double tL;
    protected double tN;
    public MessageInterface input;
    public MessageInterface output;
    protected IOBasicDevs myModel;

    public atomicSimulator() {
    }

    public atomicSimulator(IOBasicDevs atomic2) {
        this.myModel = atomic2;
        this.input = new message();
        this.output = new message();
    }

    @Override
    public double nextTN() {
        return this.tN;
    }

    public boolean equalTN(double t) {
        return t == this.tN;
    }

    @Override
    public double getTN() {
        return this.tN;
    }

    @Override
    public double getTL() {
        return this.tL;
    }

    @Override
    public synchronized MessageInterface getOutput() {
        return this.output;
    }

    public synchronized MessageInterface getInput() {
        return this.input;
    }

    @Override
    public Double nextTNDouble() {
        return new Double(this.nextTN());
    }

    @Override
    public synchronized void showModelState() {
        this.myModel.showState();
    }

    @Override
    public synchronized void initialize() {
        this.myModel.initialize();
        this.tL = 0.0;
        this.tN = this.myModel.ta();
        Logging.log("INITIALIZATION, time: " + this.tL + ", next event at: " + this.tN, 100);
        this.myModel.showState();
    }

    @Override
    public synchronized void initialize(Double d) {
        this.initialize((double)d);
    }

    @Override
    public synchronized void initialize(double currentTime) {
        this.myModel.initialize();
        this.tL = currentTime;
        this.tN = this.tL + this.myModel.ta();
        Logging.log("INITIALIZATION, time: " + this.tL + ", next event at: " + this.tN, 100);
        this.myModel.showState();
    }

    @Override
    public synchronized void DeltFunc(Double d) {
        this.DeltFunc((double)d);
    }

    public synchronized void DeltFunc(double t) {
        this.wrapDeltfunc(t, new message());
    }

    @Override
    public synchronized void wrapDeltfunc(double t) {
        this.wrapDeltfunc(t, this.input);
        this.input = new message();
    }

    @Override
    public synchronized void wrapDeltfunc(double t, MessageInterface x) {
        if (x == null) {
            System.out.println("ERROR RECEIVED NULL INPUT  " + this.myModel.toString());
            return;
        }
        if (x.isEmpty() && !this.equalTN(t)) {
            return;
        }
        if (!x.isEmpty() && this.equalTN(t)) {
            double e = t - this.tL;
            this.myModel.deltcon(e, x);
        } else if (this.equalTN(t)) {
            this.myModel.deltint();
        } else if (!x.isEmpty()) {
            double e = t - this.tL;
            this.myModel.deltext(e, x);
        }
        this.wrapDeltfuncHook2();
        this.tL = t;
        this.tN = this.tL + this.myModel.ta();
    }

    @Override
    public void computeInputOutput(Double d) {
        this.computeInputOutput((double)d);
    }

    @Override
    public void computeInputOutput(double t) {
        this.output = this.equalTN(t) ? this.myModel.Out() : new message();
        this.computeInputOutputHook1();
    }

    @Override
    public void simulate(int numIter) {
        int i = 1;
        this.tN = this.nextTN();
        while (this.tN < Double.POSITIVE_INFINITY && i <= numIter) {
            Logging.log("ITERATION " + i + " ,time: " + this.tN, 100);
            this.computeInputOutput(this.tN);
            this.showOutput();
            this.DeltFunc(this.tN);
            this.tL = this.tN;
            this.tN = this.nextTN();
            this.showModelState();
            ++i;
        }
        System.out.println("Terminated Normally at ITERATION " + i + " ,time: " + this.tN);
    }

    public void simulate(Integer i) {
        this.simulate((int)i);
    }

    @Override
    public synchronized void showOutput() {
        if (this.output == null) {
            return;
        }
        if (!this.output.isEmpty()) {
            this.output.print();
        }
    }

    @Override
    public MessageInterface makeMessage() {
        return new message();
    }

    public void simInject(double e, PortInterface p, EntityInterface value) {
        MessageInterface m = this.makeMessage();
        m.add(this.myModel.makeContent(p, value));
        this.simInject(e, m);
    }

    @Override
    public void simInject(double e, String portName, entity value) {
        this.simInject(e, new port(portName), (EntityInterface)value);
    }

    @Override
    public void simInject(double e, MessageInterface m) {
        double t = this.tL + e;
        if (e <= this.myModel.ta()) {
            this.simInjectHook1(e);
            this.wrapDeltfunc(t, m);
            System.out.println("Time: " + t + " ,input injected: ");
            m.print();
            this.myModel.showState();
            this.simInjectHook2(t);
        } else {
            System.out.println("Time: " + this.tL + " ,ERROR input rejected : elapsed time " + e + " is not in bounds.");
        }
    }

    protected void wrapDeltfuncHook2() {
    }

    protected void simInjectHook1(double e) {
    }

    protected void simInjectHook2(double newTime) {
    }

    protected void computeInputOutputHook1() {
    }

    public IOBasicDevs getModel() {
        return this.myModel;
    }
}

