/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.distributed;

import genDevs.modeling.message;
import genDevs.simulation.distributed.Util;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;

public abstract class Client {
    protected String devsName;
    protected BufferedReader inputStream;
    protected PrintStream printStream;

    public Client(String devsName_, String serverAddress, int serverPort) {
        this.devsName = devsName_;
        this.connect(serverAddress, serverPort);
        new ListenForServerMessagesThread().start();
    }

    protected abstract void initializeMessageReceived(String var1);

    protected void waitForInitialize() {
        String message2 = this.readMessage();
        if (!message2.startsWith("initialize:")) {
            System.out.println("initialize message did not arrive when expected");
        }
        this.initializeMessageReceived(message2);
    }

    protected abstract void startSimulateMessageReceived(int var1);

    protected void waitForStartSimulate() {
        String message2 = this.readMessage();
        if (!message2.startsWith("startSimulate:")) {
            System.out.println("start-simulate message did not arrive when expected");
        }
        int numIterations = (int)Double.parseDouble(message2.substring(message2.indexOf(":") + 1, message2.length()));
        System.out.println("---start simulate");
        this.startSimulateMessageReceived(numIterations);
    }

    protected abstract void inputReceived(message var1);

    protected void waitForInput() {
        String string = this.readMessage();
        System.out.println(String.valueOf(this.devsName) + " received input: " + string);
        message message2 = Util.interpret(string);
        if (message2 != null) {
            this.inputReceived(message2);
        }
    }

    protected void sendMessageToServer(String message2) {
        this.printStream.println(message2);
        System.out.println(String.valueOf(this.devsName) + " sends " + message2);
    }

    protected String readMessage() {
        try {
            return this.inputStream.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    protected void connect(String serverAddress, int serverPort) {
        Socket socket = null;
        try {
            socket = new Socket(serverAddress, serverPort);
            System.out.println("Connected!");
        }
        catch (Exception e) {
            e.printStackTrace();
            util.Util.sleep(1000L);
            this.connect(serverAddress, serverPort);
            return;
        }
        try {
            this.inputStream = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.printStream = new PrintStream(new DataOutputStream(socket.getOutputStream()));
            System.out.println("Open was successful!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected class ListenForServerMessagesThread
    extends Thread {
        protected ListenForServerMessagesThread() {
        }

        @Override
        public void run() {
            util.Util.sleep(1000L);
            Client.this.sendMessageToServer(Client.this.devsName);
            Client.this.waitForInitialize();
            Client.this.waitForStartSimulate();
            while (true) {
                Client.this.waitForInput();
            }
        }
    }
}

