/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.distributed.old;

import GenCol.Pair;
import GenCol.Relation;
import GenCol.entity;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.content;
import genDevs.modeling.message;
import genDevs.simulation.CoupledSimulatorInterface;
import genDevs.simulation.coupledSimulator;
import genDevs.simulation.distributed.old.coordServer;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Iterator;

public class simulatorProxy
extends coupledSimulator
implements CoupledSimulatorInterface,
Runnable {
    private static final long serialVersionUID = 5478355232723948119L;
    coordServer srvr;
    DataOutputStream dos;
    BufferedReader dis;
    PrintStream ps;
    Thread myThread;
    boolean quit = false;

    public simulatorProxy(Socket s, coordServer srvr) {
        this.srvr = srvr;
        this.myThread = new Thread(this);
        try {
            this.dis = new BufferedReader(new InputStreamReader(s.getInputStream()));
            this.dos = new DataOutputStream(s.getOutputStream());
            this.ps = new PrintStream(this.dos);
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(-1);
        }
        this.myThread.start();
    }

    public void stop() {
        this.quit = true;
    }

    @Override
    public void run() {
        this.waitForName();
        while (!this.quit) {
            this.waitForNextTN();
            this.waitForMsgToSend();
        }
        System.out.println("SimulatorProxy terminated");
    }

    public synchronized void waitForName() {
        IOBasicDevs comp;
        System.out.println("waiting for name");
        String compName = this.readMsg();
        this.myModel = comp = (IOBasicDevs)this.srvr.getCoupled().withName(compName);
        this.srvr.addSimulator(comp, this);
        System.out.println("name is : " + compName);
        this.srvr.register();
    }

    public synchronized void waitForNextTN() {
        String s = this.readMsg();
        this.srvr.telltN(Double.parseDouble(s));
    }

    public message interpret(String s) {
        String valueString;
        String portString;
        int valueIndex;
        int startIndex = 0;
        if (s == null || s.startsWith("none")) {
            return new message();
        }
        message m = new message();
        while (true) {
            int portIndex = s.indexOf("port: ", startIndex);
            valueIndex = s.indexOf(" value: ", startIndex);
            portString = s.substring(portIndex + 6, valueIndex).trim();
            startIndex = valueIndex + 8;
            portIndex = s.indexOf("port: ", startIndex);
            if (portIndex == -1) break;
            valueString = s.substring(valueIndex + 8, portIndex).trim();
            m.add(new content(portString, new entity(valueString)));
        }
        valueString = s.substring(valueIndex + 8, s.length()).trim();
        m.add(new content(portString, new entity(valueString)));
        return m;
    }

    public synchronized void waitForMsgToSend() {
        String s = this.readMsg();
        message output = this.interpret(s);
        this.sendMessages(output);
    }

    public synchronized void sendMessages(message output) {
        this.srvr.done();
        if (output != null && !output.isEmpty()) {
            Relation r = this.convertMsg(output);
            Iterator rit = r.iterator();
            while (rit.hasNext()) {
                Pair p = (Pair)rit.next();
                Object ds = p.getKey();
                content co = (content)p.getValue();
                simulatorProxy cn = (simulatorProxy)this.modelToSim.get(ds);
                if (cn != null) {
                    cn.putMessages(co);
                    continue;
                }
                this.srvr.putMyMessages(co);
            }
        }
    }

    public void sendInput() {
        String s = this.input.toString();
        if (s != "") {
            this.sendMsg(s);
        } else {
            this.sendMsg("none");
        }
        this.input = new message();
        this.srvr.done();
    }

    public String readMsg() {
        try {
            String MsgLine = this.dis.readLine();
            System.out.println(MsgLine);
            return MsgLine;
        }
        catch (IOException e) {
            System.out.println(e.toString());
            System.exit(-1);
            return " ";
        }
    }

    public void sendMsg(String sMsg) {
        this.ps.println(sMsg);
    }
}

