/*
 * Decompiled with CFR 0.152.
 */
package genDevs.simulation.realTime;

import GenCol.EntityInterface;
import GenCol.Pair;
import GenCol.Relation;
import GenCol.ensembleBag;
import GenCol.entity;
import genDevs.modeling.Coupled;
import genDevs.modeling.IOBasicDevs;
import genDevs.modeling.MessageInterface;
import genDevs.modeling.PortInterface;
import genDevs.modeling.content;
import genDevs.modeling.coupledDevs;
import genDevs.modeling.message;
import genDevs.modeling.port;
import genDevs.simulation.CouplingProtocolInterface;
import genDevs.simulation.coordinator;
import genDevs.simulation.realTime.CoupledRTSimulatorInterface;
import genDevs.simulation.realTime.RTCoordinatorInterface;
import genDevs.simulation.realTime.RTCoupledinjectThread;
import genDevs.simulation.realTime.RTcoupledCoordinator;
import genDevs.simulation.realTime.coupledRTSimulator;
import java.util.Iterator;

public class RTcoordinator
extends coordinator
implements RTCoordinatorInterface {
    private static final long serialVersionUID = -723548466794786503L;
    protected int numIter;
    protected int count;
    protected Thread myThread = new Thread(this);
    protected double observeTime;
    protected RTCoupledinjectThread injThread;

    public long timeInSecs() {
        return this.timeInMillis() / 1000L;
    }

    public long timeInMillis() {
        return System.currentTimeMillis();
    }

    public RTcoordinator(coupledDevs c) {
        super(c);
    }

    public RTcoordinator(coupledDevs c, boolean minimal) {
        super(c, minimal);
    }

    @Override
    public void addSimulator(IOBasicDevs comp) {
        coupledRTSimulator s = new coupledRTSimulator(comp);
        this.simulators.add(s);
        s.setRTRootParent(this);
        this.modelToSim.put(comp.getName(), s);
        this.internalModelTosim.put(comp.getName(), s);
    }

    @Override
    public void addCoordinator(Coupled comp) {
        RTcoupledCoordinator s = new RTcoupledCoordinator(comp);
        s.setRTRootParent(this);
        this.simulators.add(s);
        this.modelToSim.put(comp.getName(), s);
        this.internalModelTosim.put(comp.getName(), s);
    }

    @Override
    public void simulate(int numIter) {
        this.simulate(numIter, Double.POSITIVE_INFINITY);
    }

    public void simulate(int numIter, double observeTime) {
        this.numIter = numIter;
        this.observeTime = observeTime;
        this.tL = this.timeInSecs();
        this.tN = this.nextTN();
        this.tellAllSimulate(numIter);
        this.myThread.start();
    }

    public void tellAllSimulate(int numIter) {
        Class[] classes = new Class[]{ensembleBag.getTheClass("java.lang.Integer")};
        Object[] args = new Object[]{new Integer(numIter)};
        this.simulators.tellAll("simulate", classes, args);
    }

    public void tellAllStop() {
        this.simulators.tellAll("stopSimulate");
    }

    @Override
    public void run() {
        try {
            Thread.sleep((long)this.observeTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tellAllStop();
        System.out.println("Coordinator Terminated Normally at time: " + this.timeInMillis());
    }

    @Override
    public void wrapDeltFunc(double time) {
        this.sendDownMessages();
        this.input = new message();
        this.output = new message();
    }

    @Override
    public void sendDownMessages() {
        if (!this.input.isEmpty()) {
            Relation r = this.convertInput(this.input);
            Iterator rit = r.iterator();
            while (rit.hasNext()) {
                CouplingProtocolInterface sim;
                Pair p = (Pair)rit.next();
                Object ds = p.getKey();
                content co = (content)p.getValue();
                if (this.internalModelTosim.get(ds) instanceof CoupledRTSimulatorInterface) {
                    sim = (CoupledRTSimulatorInterface)this.internalModelTosim.get(ds);
                    sim.putMessages(co);
                    continue;
                }
                if (!(this.internalModelTosim.get(ds) instanceof RTcoupledCoordinator)) continue;
                sim = (RTcoupledCoordinator)this.internalModelTosim.get(ds);
                ((RTcoupledCoordinator)sim).putMessages(co);
            }
        }
    }

    @Override
    public void simInject(double e, String portName, entity value) {
        this.simInject(e, new port(portName), (EntityInterface)value);
    }

    @Override
    public void simInject(double e, PortInterface p, EntityInterface value) {
        MessageInterface m = this.makeMessage();
        m.add(this.myModel.makeContent(p, value));
        this.simInject(e, m);
    }

    @Override
    public void simInject(double e, MessageInterface m) {
        this.injThread = new RTCoupledinjectThread(this, e, m);
    }
}

