/*
 * Decompiled with CFR 0.152.
 */
package moea.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import moea.commons.Entity;
import moea.commons.Individual;
import moea.commons.ObjectiveVector;
import moea.commons.comparator.ComparatorObjective;
import moea.commons.comparator.ComparatorPareto;

public class Population<E extends Individual>
extends ArrayList<E> {
    private static final long serialVersionUID = -3127751095634260511L;

    public Population<E> keepNonDominated() {
        Population<Individual> rest = new Population<Individual>();
        ComparatorPareto comparator = ComparatorPareto.getInstance();
        int i = 0;
        while (i < this.size() - 1) {
            int j = i + 1;
            while (j < this.size()) {
                int compare = comparator.compare((Entity)this.get(i), (Entity)this.get(j));
                switch (compare) {
                    case -1: {
                        rest.add((Individual)this.get(j));
                        this.remove(j--);
                        break;
                    }
                    case 1: {
                        rest.add((Individual)this.get(i));
                        this.remove(i--);
                        j = this.size();
                    }
                }
                ++j;
            }
            ++i;
        }
        return rest;
    }

    public E getBestIndividual(Comparator<Entity> comparator) {
        int selected = 0;
        int i = 1;
        while (i < this.size()) {
            int compare = comparator.compare((Entity)this.get(i), (Entity)this.get(selected));
            if (compare == -1) {
                selected = i;
            }
            ++i;
        }
        return (E)((Individual)this.get(selected));
    }

    public void add(Population<E> population) {
        for (Individual individual : population) {
            this.add(individual);
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Individual individual : this) {
            buffer.append(individual.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public double calculateSpread() {
        double res = 0.0;
        double max = 0.0;
        double min = 0.0;
        Population<E> pop = new Population<E>();
        pop.add(this);
        pop.keepNonDominated();
        int i = 0;
        while (i < Entity.N) {
            ComparatorObjective comp = ComparatorObjective.getInstance(i);
            Collections.sort(pop, comp);
            max = (Double)((Individual)pop.get(pop.size() - 1)).getObjectiveVector().get(i);
            min = (Double)((Individual)pop.get(0)).getObjectiveVector().get(i);
            res += Math.pow(1.0 - min / max, 2.0);
            ++i;
        }
        res = Math.sqrt(res);
        return res;
    }

    public double calculateSpacing() {
        Population<E> pop = new Population<E>();
        pop.add(this);
        pop.keepNonDominated();
        double[] maxs = new double[Entity.N];
        int i = 0;
        while (i < Entity.N) {
            ComparatorObjective comp = ComparatorObjective.getInstance(i);
            Collections.sort(pop, comp);
            maxs[i] = (Double)((Individual)pop.get(pop.size() - 1)).getObjectiveVector().get(i);
            ++i;
        }
        ArrayList<Double> ds = new ArrayList<Double>();
        int i2 = 0;
        while (i2 < pop.size()) {
            ds.add(this.calculateMinDistance(i2, pop, maxs));
            ++i2;
        }
        double dsMean = 0.0;
        int i3 = 0;
        while (i3 < pop.size()) {
            dsMean += ((Double)ds.get(i3)).doubleValue();
            ++i3;
        }
        dsMean /= (double)pop.size();
        double res = 0.0;
        int i4 = 0;
        while (i4 < pop.size()) {
            res += Math.pow((Double)ds.get(i4) - dsMean, 2.0);
            ++i4;
        }
        res = Math.sqrt(res / (double)pop.size());
        return res;
    }

    private double calculateMinDistance(int i, Population<E> pop, double[] maxs) {
        double temp = 0.0;
        ArrayList<Double> di = new ArrayList<Double>();
        ObjectiveVector objI = ((Individual)pop.get(i)).getObjectiveVector();
        int j = 0;
        while (j < pop.size()) {
            if (i != j) {
                ObjectiveVector objJ = ((Individual)pop.get(j)).getObjectiveVector();
                temp = 0.0;
                int k = 0;
                while (k < Entity.N) {
                    temp += Math.abs((Double)objI.get(k) / maxs[k] - (Double)objJ.get(k) / maxs[k]);
                    ++k;
                }
                di.add(temp);
            }
            ++j;
        }
        Collections.sort(di);
        return (Double)di.get(0);
    }
}

