/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.algorithms;

import java.util.Collections;
import java.util.HashSet;
import moea.commons.Population;
import moea.commons.comparator.ComparatorFitness;
import moea.commons.comparator.ComparatorPareto;
import moea.moga.algorithms.Moea;
import moea.moga.genome.Chromosome;
import moea.moga.selector.VegaTournamentSelector;

public class Vega
extends Moea {
    public Vega(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation) {
        super(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation);
        this.selector = new VegaTournamentSelector(ComparatorFitness.getInstance());
    }

    @Override
    public synchronized void step() {
        if (this.externalIndividuals.size() > 0) {
            for (Chromosome externalInd : this.externalIndividuals) {
                this.pop.add(externalInd);
            }
            this.pop = this.fix(this.pop);
        }
        this.pop = this.generate(this.pop);
        ++this.currentGeneration;
    }

    public synchronized Population<Chromosome> fix(Population<Chromosome> pop) {
        Population<Chromosome> newPop = new Population<Chromosome>();
        double currentAll = Double.MAX_VALUE;
        double currentInd = Double.MAX_VALUE;
        HashSet<Integer> indexes = new HashSet<Integer>();
        Collections.sort(pop, ComparatorPareto.getInstance());
        Chromosome ind = null;
        int i = 0;
        while (i < pop.size()) {
            ind = (Chromosome)pop.get(i);
            currentInd = (Double)ind.getObjectiveVector().get(0);
            if (currentAll != currentInd) {
                newPop.add(ind);
                indexes.add(i);
                if (newPop.size() == this.popSizeMax) break;
                currentAll = currentInd;
            }
            ++i;
        }
        int diff = this.popSizeMax - newPop.size();
        int k = 0;
        while (diff > 0) {
            ind = (Chromosome)pop.get(k);
            if (!indexes.contains(k)) {
                newPop.add(ind);
                --diff;
            }
            ++k;
        }
        return newPop;
    }
}

