/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import moea.commons.Population;
import moea.moga.algorithms.Spea2;
import moea.moga.examples.Profile;
import moea.moga.genome.Chromosome;

public class ProfileThreaded
extends Profile {
    public static void main(String[] args) throws Exception {
        System.out.print("XML profile: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String proPath = br.readLine();
        ProfileThreaded.initializeProblem(proPath);
        BufferedWriter logger = new BufferedWriter(new FileWriter(new File(String.valueOf(proPath) + ".SSSS.log")));
        int i = 0;
        while (i < 1) {
            System.out.println("Iteration number: " + i);
            int numSubPops = 4;
            ArrayList populations = new ArrayList();
            int j = 0;
            while (j < numSubPops) {
                Population<ProfileThreaded> popIni = new Population<ProfileThreaded>();
                int k = 0;
                while (k < 200) {
                    ProfileThreaded individual = new ProfileThreaded();
                    popIni.add(individual);
                    ++k;
                }
                populations.add(popIni);
                ++j;
            }
            Spea2 algorithm1 = new Spea2("Island1", (Population)populations.get(0), 2000, 0.8, 0.01);
            Spea2 algorithm2 = new Spea2("Island2", (Population)populations.get(1), 2000, 0.8, 0.01);
            Spea2 algorithm3 = new Spea2("Island3", (Population)populations.get(2), 2000, 0.8, 0.01);
            Spea2 algorithm4 = new Spea2("Island4", (Population)populations.get(3), 2000, 0.8, 0.01);
            algorithm1.addNeighbor(algorithm2);
            algorithm2.addNeighbor(algorithm3);
            algorithm3.addNeighbor(algorithm4);
            algorithm4.addNeighbor(algorithm1);
            double start = System.currentTimeMillis();
            algorithm1.start();
            algorithm2.start();
            algorithm3.start();
            algorithm4.start();
            algorithm1.join();
            algorithm2.join();
            algorithm3.join();
            algorithm4.join();
            double end = System.currentTimeMillis();
            System.out.println("Time: " + (end - start) / 1000.0);
            Population<Chromosome> pop = new Population<Chromosome>();
            pop.add(algorithm1.getPopulation());
            pop.add(algorithm2.getPopulation());
            pop.add(algorithm3.getPopulation());
            pop.add(algorithm4.getPopulation());
            logger.write(pop.toString());
            ++i;
        }
        logger.flush();
        logger.close();
    }
}

