/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.genome;

import moea.commons.Individual;

public abstract class Chromosome
extends Individual {
    public abstract Chromosome clone();

    public Chromosome() {
    }

    public Chromosome(Chromosome src) {
        super(src);
    }

    public boolean crossover(double probabilityOfCrossover, Chromosome dad, Chromosome sister, Chromosome brother) {
        if (Math.random() < probabilityOfCrossover) {
            int pos;
            int j = pos = 1 + (int)((double)(Chromosome.getM() - 1) * Math.random());
            while (j < Chromosome.getM()) {
                sister.x[j] = dad.x[j];
                ++j;
            }
            j = pos;
            while (j < Chromosome.getM()) {
                brother.x[j] = this.x[j];
                ++j;
            }
            sister.invalidateScores();
            brother.invalidateScores();
            return true;
        }
        return false;
    }

    public void mutate(double probabilityOfMutation) {
        double gene;
        double sigma;
        int pos;
        int assuredMutated = (int)((double)M * probabilityOfMutation);
        double randomMutated = (double)M * probabilityOfMutation - (double)assuredMutated;
        int j = 0;
        while (j < assuredMutated) {
            pos = (int)(Math.random() * (double)M);
            sigma = xU[pos] - xL[pos];
            gene = xL[pos] + Math.random() * sigma;
            if (this.x[pos] != gene) {
                this.invalidateScores();
                this.x[pos] = gene;
            }
            ++j;
        }
        if (Math.random() < randomMutated) {
            pos = (int)(Math.random() * (double)M);
            sigma = xU[pos] - xL[pos];
            gene = xL[pos] + Math.random() * sigma;
            if (this.x[pos] != gene) {
                this.invalidateScores();
                this.x[pos] = gene;
            }
        }
    }
}

