/*
 * Decompiled with CFR 0.152.
 */
package devs.soa.service;

import devs.soa.service.SimulatorServiceInterface;
import devs.soa.stub.SimulatorStub;

public class SimulatorService
implements SimulatorServiceInterface {
    protected SimulatorStub service;

    public SimulatorService(String endPoint, boolean session) throws Exception {
        this.service = new SimulatorStub(endPoint);
        this.service._getServiceClient().getOptions().setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        this.service._getServiceClient().getOptions().setProperty("customCookieID", (Object)"ASP.NET_SessionId");
        if (session) {
            this.service._getServiceClient().getOptions().setManageSession(true);
        }
    }

    @Override
    public void initialize(double t) throws Exception {
        SimulatorStub.Initialize args = new SimulatorStub.Initialize();
        args.setT(Double.toString(t));
        this.service.initialize(args);
    }

    @Override
    public double getTN() throws Exception {
        SimulatorStub.GetTNResponse response = this.service.getTN();
        return Double.parseDouble(response.getT());
    }

    @Override
    public void lambda(double t) throws Exception {
        SimulatorStub.Lambda args = new SimulatorStub.Lambda();
        args.setT(Double.toString(t));
        this.service.lambda(args);
    }

    @Override
    public String[] getOutput(String portName) throws Exception {
        SimulatorStub.GetOutput args = new SimulatorStub.GetOutput();
        args.setPortName(portName);
        SimulatorStub.GetOutputResponse response = this.service.getOutput(args);
        return response.getXmlValues();
    }

    @Override
    public void receive(String portTo, String[] xmlValues) throws Exception {
        SimulatorStub.Receive args = new SimulatorStub.Receive();
        args.setPortTo(portTo);
        args.setXmlValues(xmlValues);
        this.service.receive(args);
    }

    @Override
    public void deltfcn(double t) throws Exception {
        SimulatorStub.Deltfcn args = new SimulatorStub.Deltfcn();
        args.setT(Double.toString(t));
        this.service.deltfcn(args);
    }

    @Override
    public void setTimeOutInMilliSeconds(long milliSeconds) throws Exception {
        SimulatorStub.SetTimeOutInMilliSeconds args = new SimulatorStub.SetTimeOutInMilliSeconds();
        args.setTimeOutInMilliSeconds(Long.toString(milliSeconds));
        this.service.setTimeOutInMilliSeconds(args);
    }

    @Override
    public void setModel(String xmlAtomicAsString) throws Exception {
        SimulatorStub.SetModel args = new SimulatorStub.SetModel();
        args.setXmlModelAsString(xmlAtomicAsString);
        this.service.setModel(args);
    }
}

