/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.Job;
import java.util.Collection;
import xdevs.kernel.modeling.AtomicImpl;
import xdevs.kernel.modeling.MessageImpl;
import xdevs.kernel.modeling.api.Message;

public class Generator
extends AtomicImpl {
    private static final long serialVersionUID = 1L;
    public static final String stop = "stop";
    public static final String out = "out";
    protected double period;
    protected int count;

    public Generator(String name, double period) {
        super(name);
        this.addInport(stop);
        this.addOutport(out);
        this.period = period;
        this.setSigma(period);
        this.count = 0;
    }

    public Generator() {
        this("Generator", 5.0);
    }

    public void deltint() {
        ++this.count;
        this.setSigma(this.period);
    }

    public void deltext(double e, Message x) {
        this.setSigma(this.getSigma() - e);
        Collection values = x.getValuesOnPort(stop);
        if (!values.isEmpty()) {
            this.setSigma(Double.POSITIVE_INFINITY);
        }
    }

    public Message lambda() {
        Job job = new Job("" + this.count + "");
        MessageImpl msg = new MessageImpl();
        msg.add(out, (Object)job);
        return msg;
    }

    public double getPeriod() {
        return this.period;
    }

    public void setPeriod(double period) {
        this.period = period;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

