/*
 * Decompiled with CFR 0.152.
 */
package devs.soa.simulation;

import devs.soa.modeling.Connection;
import devs.soa.service.SimulatorService;
import devs.soa.service.SimulatorServiceInterface;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Coordinator {
    private Element xmlModel;
    private HashMap<String, SimulatorServiceInterface> simulators;
    private HashSet<Connection> connections;
    private double tL;
    private double tN;
    public StringBuffer console = new StringBuffer();

    public Coordinator(String name, Element xmlCoupled) throws Exception {
        this.xmlModel = xmlCoupled;
        this.simulators = new HashMap();
        this.connections = new HashSet();
        NodeList xmlComponentList = this.xmlModel.getChildNodes();
        for (int i = 0; i < xmlComponentList.getLength(); ++i) {
            Node xmlComponentAsNode = xmlComponentList.item(i);
            if (xmlComponentAsNode.getNodeType() != 1) continue;
            Element xmlComponent = (Element)xmlComponentAsNode;
            String nodeName = xmlComponent.getNodeName();
            if (nodeName.equals("coupled") || nodeName.equals("atomic")) {
                String nameComponent = xmlComponent.getAttribute("name");
                String hostComponent = xmlComponent.getAttribute("host");
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(xmlComponent), result);
                String xmlComponentAsString = writer.toString();
                SimulatorService simulationService = new SimulatorService(hostComponent, true);
                simulationService.setModel(xmlComponentAsString);
                this.simulators.put(nameComponent, simulationService);
                continue;
            }
            if (!nodeName.equals("connection")) continue;
            String simulatorFrom = xmlComponent.getAttribute("atomicFrom");
            String portFrom = xmlComponent.getAttribute("portFrom");
            String simulatorTo = xmlComponent.getAttribute("atomicTo");
            String portTo = xmlComponent.getAttribute("portTo");
            Connection connection = new Connection(simulatorFrom, portFrom, simulatorTo, portTo);
            this.connections.add(connection);
        }
        this.initialize(0.0);
    }

    public void initialize(double t) throws Exception {
        Set<Map.Entry<String, SimulatorServiceInterface>> pairs = this.simulators.entrySet();
        for (Map.Entry<String, SimulatorServiceInterface> pair : pairs) {
            pair.getValue().initialize(t);
        }
        this.tL = t;
        this.tN = t + this.ta(t);
    }

    private double ta(double t) throws Exception {
        double tn = Double.POSITIVE_INFINITY;
        double tnAux = Double.POSITIVE_INFINITY;
        Set<Map.Entry<String, SimulatorServiceInterface>> pairs = this.simulators.entrySet();
        for (Map.Entry<String, SimulatorServiceInterface> pair : pairs) {
            tnAux = pair.getValue().getTN();
            if (!(tnAux < tn)) continue;
            tn = tnAux;
        }
        return tn - t;
    }

    private void lambda(double t) throws Exception {
        Set<Map.Entry<String, SimulatorServiceInterface>> pairs = this.simulators.entrySet();
        for (Map.Entry<String, SimulatorServiceInterface> pair : pairs) {
            pair.getValue().lambda(t);
        }
        this.propagateOutput();
    }

    private void propagateOutput() throws Exception {
        for (Connection connection : this.connections) {
            SimulatorServiceInterface simulatorFrom = this.simulators.get(connection.getSimulatorFrom());
            String[] xmlValues = simulatorFrom.getOutput(connection.getPortFrom());
            if (xmlValues == null) continue;
            SimulatorServiceInterface simulatorTo = this.simulators.get(connection.getSimulatorTo());
            simulatorTo.receive(connection.getPortTo(), xmlValues);
        }
    }

    private void deltfcn(double t) throws Exception {
        Set<Map.Entry<String, SimulatorServiceInterface>> pairs = this.simulators.entrySet();
        for (Map.Entry<String, SimulatorServiceInterface> pair : pairs) {
            pair.getValue().deltfcn(t);
        }
        this.tL = t;
        this.tN = this.tL + this.ta(t);
    }

    public String simulate(long numIterations) throws Exception {
        double t = this.tN;
        for (long counter = 1L; counter < numIterations && t < Double.POSITIVE_INFINITY; ++counter) {
            this.lambda(t);
            this.deltfcn(t);
            t = this.tN;
        }
        return "Simulator";
    }
}

